﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;

namespace AZVIC.Ei8htPOS.BAL
{
    [DataObjectAttribute()]
    public static class SubscriptionBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static Subscription GetItem(Guid SubscriptionID, string keyword)
        {
            return SubscriptionDB.GetItem(SubscriptionID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<Subscription> GetList(Guid SubscriptionID, string keyword)
        {
            return SubscriptionDB.GetList(SubscriptionID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataTable GetDataTable(Guid SubscriptionID, string keyword)
        {
            return SubscriptionDB.GetDataTable(SubscriptionID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataSet GetDataSet(Guid SubscriptionID, string keyword)
        {
            return SubscriptionDB.GetDataSet(SubscriptionID, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(Subscription myContactMessage)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                SubscriptionDB.Save(myContactMessage);

                myTransactionScope.Complete();
                return true;
            }
        }
    }
}
